varying vec2 p_textureCoord;

varying vec4 p_color;
uniform sampler2D base_texture;
uniform float block_size;
uniform float block_ratio;

void main()
{
	vec2 block_scale = vec2(block_size, block_size);
    vec2 real_textureCoord = floor(p_textureCoord * block_scale);
    real_textureCoord.xy /= block_scale;         
   
    vec4 resultColor = texture2D(base_texture, real_textureCoord) * p_color;
    gl_FragColor = resultColor;
}
